#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

typedef unsigned long long int Z;

const Z M = 1000000007;

Z N, D, X;

Z T[2005][2005];
Z S[2005];

Z pow(Z a, Z b) {
	if(b == 0) return 1;
	if(b % 2 == 1) return (a * pow(a, b - 1)) % M;
	Z x = pow(a, b / 2);
	return (x * x) % M;
}

Z inv(Z x) {
	return pow(x, M - 2);
}

int main() {
	cin.sync_with_stdio(false);
	
	while(true) {
		cin >> N;
		if(N == 0) break;
		cin >> D >> X;
		
		for(Z i = 0; i <= N; ++i) T[0][i] = 0;
		T[0][0] = 1;
		Z ret = 0;
		Z binom = D;
		for(Z d = 1; d <= min(N, D); ++d) {
			S[0] = 0;
			for(Z i = 0; i <= N; ++i) {
				S[i + 1] = S[i] + T[d - 1][i];
				S[i + 1] %= M;
			}
			for(Z n = 0; n <= N; ++n) {
				T[d][n] = S[n] + M - ((n + 1 >= X) ? S[n - X + 1] : 0);
				T[d][n] %= M;
			}
			
			ret += (binom * T[d][N]) % M;
			ret %= M;
			binom *= ((D - d) % M);
			binom %= M;
			binom *= inv(d + 1);
			binom %= M;
		}
		
		cout << ret << "\n";
	}
	
	return 0;
}
